package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysRole;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/**
 * <p>
 * 角色 服务类
 * </p>
 *
 * @author mapp
 * @since 2019-12-06
 */
public interface SysRoleService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param isSuperAdmin 是否超级管理员
     * @return
     */
    Page<SysRole> page(Page<SysRole> page, SysRole entity, boolean isSuperAdmin);

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param isSuperAdmin 是否超级管理员
     * @return
     */
    Page<SysRole> roleSetPage(Page<SysRole> page, SysRole entity, boolean isSuperAdmin);

    /*****
     * 列表查询
     * @param entity 实体类
     * @param isSuperAdmin 是否超级管理员
     * @return
     */
    List<SysRole> roleSetDataList(SysRole entity, boolean isSuperAdmin);

    /*****
     * 查询用户角色
     * @param entity 实体类
     * @param page 分页信息
     * @param userId 用户主键Id
     * @param isSuperAdmin 是否超级管理员
     * @return
     */
    Page<SysRole> queryUserOwnRolePageByUserId(SysRole entity, Page<SysRole> page, String userId, boolean isSuperAdmin);

    /*****
     * 查询用户角色
     * @param userId 用户主键Id
     * @param isAdmin 是否超管
     * @return
     */
    List<SysRole> queryUserOwnRoleListByUserId(String userId, boolean isAdmin);

    /*****
     * 保存组系统角色数据
     * @param entity
     * @param isCreate
     * @param user
     */
    void saveOrUpdate(SysRole entity, boolean isCreate, SysUser user);

    /*****
     * 根据ID获取角色信息
     * @param id
     * @return
     */
    SysRole getEntityInfoById(String id);

    /*****
     * 根据ID删除角色信息
     * @param ids 　角色ID
     * @param user
     * @return
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 获取角色总数
     * @param subSysId 子系统主键Id
     * @return
     */
    Integer getRoleCountBySubSysId(String subSysId);

    /*****
     * 查询用户角色
     * @param userId 用户主键Id
     * @return
     */
    List<SysRole> queryUserRoleRelByUserId(String userId);

    /******
     * 角色下拉数据
     * @param filter
     * @param isSuperAdmin
     * @return
     */
    List<ComboboxVo> queryEntityInfoCombobox(String filter, boolean isSuperAdmin);

    /******
     * 获取角色信息通过编码
     * @param code
     * @return
     */
    SysRole getEntityInfoByCode(String code);

    /******
     * 获取默认角色信息
     * @return
     */
    List<SysRole> getSystemDefaultEntityInfo();

    /*******
     * 获取角色信息
     * @param roleCategory 角色类别
     * @param subSysId 子系统Id
     * @return
     */
    List<SysRole> getEntityInfoByRoleCategoryAndSubSysId(String roleCategory, String subSysId);
}

