package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysRole;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysRoleMenu;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysRoleMenuService
 * @author chris
 * @description 角色菜单接口服务层接口
 * @version 1.0
 * @date 2019-12-27 11:34
 */
public interface SysRoleMenuService {

    /****
     * 获取菜单关联角色总数
     * @param menuId 菜单主键Id
     * @return
     */
    Integer getRoleMenuRelCountByMenuId(String menuId);

    /****
     * 获取角色关联菜单总数
     * @param roleId 角色主键Id
     * @return
     */
    Integer getRoleMenuRelCountByRoleId(String roleId);

    /******
     * 保存角色和菜单关联关系
     * @param roleId 角色主键Id
     * @param menuIds 菜单主键Id集合
     * @param user 当前登录用户
     */
    void saveRoleMenuRel(String roleId, String menuIds, SysUser user);

    /******
     * 解除角色和菜单关联关系
     * @param menuId 菜单主键Id
     * @param roleIds 角色主键Id集合
     * @param user 当前登录用户
     */
    void relieveRoleMenuRel(String menuId, String roleIds, SysUser user);

    /*****
     * 查询角色关联菜单的信息
     * @param page 分页信息
     * @param entity
     * @param isAdmin 是否管理员
     * @return
     */
    Page<SysMenu> queryRoleMenuPageData(Page<SysMenu> page, SysRoleMenu entity, boolean isAdmin);

    /*****
     * 查询菜单关联角色的信息
     * @param page 分页信息
     * @param entity
     * @param isAdmin 是否管理员
     * @return
     */
    Page<SysRole> queryMenuRelRolePageData(Page<SysRole> page, SysRoleMenu entity, boolean isAdmin);

    /*****
     * 查询角色关联菜单的信息
     * @param roleId 角色主键Id
     * @return
     */
    List<TreeDataVo> queryRoleMenuTreeData(String roleId);

    /*****
     * 查询角色关联可用菜单的信息
     * @param roleId 角色主键Id
     * @return
     */
    List<TreeDataVo> queryRoleUsableMenuTreeData(String roleId);
}
