package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysOrgService
 * @author chris
 * @description 组织机构service接口
 * @version 1.0
 * @date 2019-12-23 09:24
 */
public interface SysOrgService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<SysOrg> page(Page<SysOrg> page, SysOrg entity, String curUserOrgId);

    /*****
     * 列表查询
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<SysOrg> dataList(SysOrg entity, String curUserOrgId);

    /*****
     * 独立执法主体分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<SysOrg> dlzfPageData(Page<SysOrg> page, SysOrg entity, String curUserOrgId);

    /*****
     * 保存组织机构数据
     * @param entity
     * @param isCreate
     * @param user 当前登录用户
     */
    void saveOrUpdate(SysOrg entity, boolean isCreate, SysUser user);

    /*****
     * 保存案件起始编码
     * @param orgId 组织机构Id
     * @param orgCaseCode 案件起始编码
     * @param user 当前登录用户
     */
    void saveCaseCode(String orgId, String orgCaseCode, SysUser user);

    /*****
     * 保存财政归属
     * @param orgId 组织机构Id
     * @param capitalOwnerId 归属地Id
     * @param imposeDeptCode 执收单位编码
     * @param imposeDeptName 执收单位名称
     * @param user
     */
    void saveCapital(String orgId, String capitalOwnerId, String imposeDeptCode, String imposeDeptName, SysUser user);

    /*****
     * 保存案处机构信息
     * @param orgId 组织机构Id
     * @param orgDealId 案处机构Id
     * @param user
     */
    void saveCaseDeal(String orgId, String orgDealId, SysUser user);

    /*****
     * 获取组织机构信息
     * @param id 主键ID
     * @return
     */
    SysOrg getEntityInfoById(String id);

    /*****
     * 删除组织机构信息
     * @param ids
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /****
     * 获取组织机构树数据
     * @param orgId 组织机构id
     * @param filter 关键字过滤
     * @param rootOrgId 组织机构根节点Id
     * @return
     */
    List<TreeDataVo> queryOrgTreeData(String orgId, String filter, String rootOrgId);

    /****
     * 获取组织机构树数据
     * @param orgId 组织机构id
     * @param filter 关键字过滤
     * @param rootOrgId 组织机构根节点Id
     * @return
     */
    List<TreeDataVo> queryOrgParTreeData(String orgId, String filter, String rootOrgId);

    /****
     * 获取跨单位组织机构树
     * @param orgId 组织机构id
     * @param filter 关键字过滤
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<TreeDataVo> queryCrossUnitOrgTreeData(String orgId, String filter, String curUserOrgId);

    /****
     * 获取同级的组织机构树数据
     * @param orgId 组织机构id
     * @param filter 关键字过滤
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<TreeDataVo> querySameLevelOrgTree(String orgId, String filter, String curUserOrgId);

    /****
     * 获取组织机构超限发函树数据
     * @param filter 关键字过滤
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<TreeDataVo> queryCxfhOrgTreeData(String filter, String curUserOrgId);

    /*****
     * 获取省市组织机构树数据
     * @param filter 关键字过滤
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<TreeDataVo> queryShengShiOrgTreeData(String filter, String curUserOrgId);

    /****
     * 获取所有组织机构树数据
     * @param filter 关键字过滤
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<TreeDataVo> queryAllSysOrgTreeData(String filter, String curUserOrgId);

    /*******
     * 获取当前组织机构的下一个序号
     * @param orgPid 组织机构父级Id
     * @return
     */
    Integer getOrgNextOrderNoByOrgPid(String orgPid);

    /*******
     * 判断是否独立执法主体
     * @param orgId 组织机构Id
     * @return
     */
    boolean judgeAutonomySubject(String orgId);

    /*******
     * 验证数据
     * @param orgId 组织机构Id
     * @param optType 操作类型:1-设置案件编号,2-设置财政归属,3-设置案件处理机构
     * @return
     */
    boolean verifyDataByIdAndType(String orgId, String optType);

    /*******
     * 获取所有组织机构
     * @return
     */
    List<SysOrg> getSysOrgAllData();

    /*******
     * 查询组织机构子集分页信息
     * @param page 分页信息
     * @param entity 实体类
     * @param isShowParent 是否显示父级
     * @return
     */
    Page<SysOrg> childPage(Page<SysOrg> page, SysOrg entity, boolean isShowParent);

    /**
     * 根据机构id获取机构信息
     *
     * @param orgName 机构名称
     * @return
     */
    SysOrg getEntityInfoByName(String orgName);

    /****
     * 根据机构父级Id查询子集信息
     * @param orgPid 组织机构父级Id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<SysOrg> getEntityChildListByPid(String orgPid, String curUserOrgId);

    /****
     * 根据机构Id查询子集信息
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<SysOrg> querySubOrgId(String curUserOrgId);

    /******
     * 执法公示系统处理单位下拉数据
     * @param filter 关键字
     * @param containFilters 数据中包含的关键字
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ComboboxVo> queryEntityInfoComboboxByContainFiltersAndOrgId(String filter, String containFilters, String curUserOrgId);

    /******
     * 获取组织机构下拉数据
     * @param filter 关键字
     * @param containFilters 数据中包含的关键字
     * @param xzqhId 行政区划Id
     * @return
     */
    List<ComboboxVo> queryEntityInfoComboboxByContainFiltersAndXzqhId(String filter, String containFilters, String xzqhId);
}
