package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysNotice;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysSubSystem;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

/****
 * @className SysNoticeService
 * @author chris
 * @description 系统公告服务层接口
 * @version 1.0
 * @date 2020-07-12 20:11
 */
public interface SysNoticeService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户的组织机构Id
     * @return
     */
    Page<SysNotice> pageData(Page<SysNotice> page, SysNotice entity, String curUserOrgId);

    /*****
     * 保存系统公告数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user
     */
    void saveOrUpdate(SysNotice entity, boolean isCreate, SysUser user);

    /*****
     * 获取系统公告信息
     * @param id 主键ID
     * @return
     */
    SysNotice getEntityInfoById(String id);

    /*****
     * 删除系统公告信息
     * @param ids 主键Id集合
     * @param user
     */
    void deleteDataByIds(String ids, SysUser user);
}
