package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysNoticeReceiverService
 * @author ChrisYolanda
 * @description 系统公告接收单位服务层接口
 * @version 1.0
 * @date 2020-10-13 20:57
 */
public interface SysNoticeReceiverService {

    /*****
     * 保存系统公告接收单位信息
     * @param ggId 公告Id
     * @param jsdwIds 接收单位Id集合
     * @param user 当前登录用户
     */
    void saveOrUpdate(String ggId, String jsdwIds, SysUser user);

    /******
     * 逻辑删除公告接收单位信息
     * @param ggId 公告Id
     * @param user 当前登录用户
     */
    void deleteEntityInfoByGgId(String ggId, SysUser user);

    /******
     * 获取接收单位Id集合
     * @param ggId 公告Id
     * @return
     */
    List<String> getSysNoticeReceiverOrgIdsByGgId(String ggId);

    /******
     * 获取接收单位名称集合
     * @param ggId 公告Id
     * @return
     */
    List<String> getSysNoticeReceiverOrgNamesByGgId(String ggId);
}
