package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysMutexRole;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysRole;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysMutexRoleService
 * @author chris
 * @description 互斥角色服务层接口
 * @version 1.0
 * @date 2020-07-12 20:11
 */
public interface SysMutexRoleService {

    /******
     * 获取角色的互斥角色分页信息
     * @param page
     * @param roleId
     * @return
     */
    Page<SysRole> mutexRolePage(Page<SysRole> page, String roleId);

    /******
     * 获取角色的互斥角色列表信息
     * @param entity
     * @param roleId
     * @return
     */
    List<SysRole> mutexRoleList(SysRole entity, String roleId);

    /*******
     * 获取角色的互斥角色信息
     * @param roleId
     * @return
     */
    List<SysMutexRole> queryRoleMutexRoleDataList(String roleId);

    /*****
     * 保存互斥角色信息数据
     * @param roleId 角色ID
     * @param mutexRoleIds 互斥角色Id集合
     * @param user 当前登录用户
     */
    void saveOrUpdate(String roleId, String mutexRoleIds, SysUser user);

    /*****
     * 解除互斥角色信息数据
     * @param roleId 角色ID
     * @param mutexRoleIds 互斥角色Id集合
     * @param user 当前登录用户
     */
    void relieve(String roleId, String mutexRoleIds, SysUser user);

    /*****
     * 校验角色之间是否存在互斥关系
     * @param userId 用户Id
     * @param roleIds 角色Id集合
     * @return
     */
    boolean verifyRoleExistMutexRel(String userId, String roleIds);
}
