package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.AppMenuVo;
import com.kdgcsoft.jt.xzzf.common.component.AuthMenuVo;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 菜单 服务类
 * </p>
 *
 * @author mapp
 * @since 2019-12-03
 */
public interface SysMenuService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<SysMenu> page(Page<SysMenu> page, SysMenu entity);

    /*****
     * 保存组系统菜单数据
     * @param entity
     * @param isCreate 是否创建
     * @param user 当前登录用户
     */
    void saveOrUpdate(SysMenu entity, boolean isCreate, SysUser user);

    /******
     * 删除菜单信息
     * @param ids
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /******
     * 修改菜单状态信息
     * @param ids
     * @param user 当前登录用户
     */
    void modifyStatusDataByIds(String ids, SysUser user);

    /*****
     * 根据ID获取菜单信息
     * @param id
     * @return
     */
    SysMenu getEntityInfoById(String id);

    /******
     * 获取菜单总数
     * @param subSysId 子系统Id
     * @return
     */
    Integer getMenuCountBySubSysId(String subSysId);

    /*****
     * 获取所有菜单
     * @param entity
     * @return
     */
    List<TreeDataVo> queryMenuTreeDataList(SysMenu entity);

    /*****
     * 查询角色菜单信息
     * @param roleId 角色主键Id
     * @return
     */
    List<SysMenu> queryRoleMenuByRoleId(String roleId);

    /*******
     * 获取当前菜单的下一个序号
     * @param menuPid 菜单父级Id
     * @return
     */
    Integer getMenuNextOrderNoByMenuPid(String menuPid);

    /********
     * 获取App用户所有系统菜单信息
     * @param userId 当前登录用户Id
     * @param filter 关键字过滤
     * @return
     */
    List<AppMenuVo> queryAppMenuDataList(String userId, String filter);

    /******
     * 判断是否符合添加菜单或者按钮
     * @param menuPid
     * @param menuType
     * @return
     */
    boolean judgeAddMenuOrBtnByMenuPidAndType(String menuPid, String menuType);

    /*******
     * 获取权限菜单信息
     * @param userId 当前用户Id
     * @param subSysId 所属子系统Id
     * @return
     */
    List<AuthMenuVo> queryAuthMenuByUserIdAndSubSysId(String userId, String subSysId);

    /******
     * 获取App用户所有的菜单信息
     * @param userId 用户Id
     * @param filter 关键字过滤
     * @return
     */
    Map<String, Object> queryAppUserAllMenuInfo(String userId, String filter);
}

