package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDzqztp;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysDzqztpService
 * @author chris
 * @description 电子签章图片服务层接口
 * @version 1.0
 * @date 2020-06-17 22:01
 */
public interface SysDzqztpService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前组织机构Id
     * @param user 当前登录用户
     * @return
     */
    Page<SysDzqztp> page(Page<SysDzqztp> page, SysDzqztp entity, String curUserOrgId, SysUser user);

    /*****
     * 用户未关联签章信息分页查询
     * @param page 分页信息
     * @param entity 用户实体类
     * @param curUserOrgId 当前组织机构Id
     * @param isAdmin 是否管理员
     * @return
     */
    Page<SysUser> userUnRelSignPage(Page<SysUser> page, SysUser entity, String curUserOrgId, boolean isAdmin);

    /*****
     * 用户未关联签章信息列表查询
     * @param entity 用户实体类
     * @param curUserOrgId 当前组织机构Id
     * @param isAdmin 是否管理员
     * @return
     */
    List<SysUser> userUnRelSignList(SysUser entity, String curUserOrgId, boolean isAdmin);

    /****
     * 获取电子签章信息
     * @param id 主键ID
     * @return
     */
    SysDzqztp getEntityInfoById(String id);

    /*****
     * 删除用户电子签章信息
     * @param ids 电子签章信息Id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 删除用户电子签章信息
     * @param userId 用户Id
     * @param user 当前登录用户
     */
    void deleteEntityInfoByUserId(String userId, SysUser user);

    /*****
     * 校验签章
     * @param entity 实体类
     * @return
     */
    SysDzqztp checkQianZhang(SysDzqztp entity);

    /******
     * 保存电子签章信息
     * @param entity 电子签章信息
     * @param isCreate 是否新增
     * @param user 当前登录用户
     */
    void saveOrUpdate(SysDzqztp entity, boolean isCreate, SysUser user);

    /*****
     * 重置密码
     * @param ids 用户id集合
     * @param user 当前登录用户
     */
    void resetPwd(String ids, SysUser user);

    /*****
     * 初始化默认密码
     * @param ids 用户id集合
     * @param user 当前登录用户
     */
    void restoreDefaultPwd(String ids, SysUser user);

    /*****
     * 修改密码
     * @param entity
     * @param user 当前登录用户
     */
    void modifyPwd(SysDzqztp entity, SysUser user);

    /******
     * 获取电子签章信息
     * @param entity 电子签章信息
     * @param curUserOrgId 当前登录用户组织机构Id
     * @param user 当前登录用户
     * @return
     */
    List<SysDzqztp> getEntityInfoBySignInfo(SysDzqztp entity, String curUserOrgId, SysUser user);

    /*****
     * 修改电子签章的用户名
     * @param id 签章主键Id
     * @param newAct 新的签章用户名
     * @param user 当前登录用户
     */
    void modifySignAct(String id, String newAct, SysUser user);

    /****
     * 获取用户电子签章信息
     * @param userId 用户主键Id
     * @return
     */
    SysDzqztp getEntityInfoByUserId(String userId);

    /****
     * 获取电子签章信息
     * @param orgId 组织机构主键Id
     * @param qianZhangLeiBie 签章类别
     * @return
     */
    SysDzqztp getEntityInfoByOrgIdAndType(String orgId, String qianZhangLeiBie);

    /****
     * 获取电子签章信息
     * @param orgId 组织机构主键Id
     * @param qianZhangLeiBie 签章类别
     * @param qianZhangYongTu 签章用途
     * @return
     */
    SysDzqztp getEntityInfoByOrgIdAndTypeAndCategory(String orgId, String qianZhangLeiBie, String qianZhangYongTu);

    /*****
     * 同步电子签章信息
     * @param userId 用户Id
     * @param user 当前登录用户
     * @param isAdmin 是否管理员
     */
    void syncSysDzqztpInfoByUserId(String userId, SysUser user, boolean isAdmin);

    /******
     * 获取签章信息
     * @param signAct 签章账号
     * @param signPwd 签章密码(明文)
     * @param signType 签章类别
     * @return
     */
    SysDzqztp getEntityInfoBySignActAndSignPwdAndSignType(String signAct, String signPwd, String signType);

    /******
     * 根据签章号，获取签章信息
     * @param qianZhangHao 签章号
     * @return
     */
    SysDzqztp getInfoByQianZhangHao(String qianZhangHao);

    /******
     * 根据签章ids，获取未签发的签章信息
     * @param ids 签章id
     * @return
     */
    List<SysDzqztp> selectInfoByIds(String ids);

    /**
     * 根据主键更新
     *
     * @param sysDzqztp
     * @return
     */
    boolean updateById(SysDzqztp sysDzqztp);

    /**
     * 查询已上传签章图片的数据（通过id）
     *
     * @param ids
     * @return
     */
    List<SysDzqztp> selectUploadedInfoByIds(String ids);
}
