package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDic;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/**
 * @Description: 字典查询接口
 * @Author: zd
 * @Date: 2019/12/20
 */
public interface SysDicService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<SysDic> page(Page<SysDic> page, SysDic entity);

    /*****
     * 保存数据字典数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param isAddDicVal 是否新增数据字典的值
     * @param user 当前登录用户
     */
    void saveOrUpdate(SysDic entity, boolean isCreate, boolean isAddDicVal, SysUser user);

    /******
     * 获取数据字典信息
     * @param id 主键ID
     * @return
     */
    SysDic getEntityInfoById(String id);

    /*****
     * 删除数据字典信息
     * @param ids 主键Id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 根据字典编码查询字典并排序
     * @param dictCode
     * @return
     */
    List<ComboboxVo> queryEntityCombobox(String dictCode);

    /******
     * 获取所有数据字典信息
     * @return
     */
    List<SysDic> getAll();

    /*****
     * 获取字典文本信息
     * @param dictCode 字典编码
     * @param dictValue 字典值
     * @return
     */
    String getDictText(String dictCode, String dictValue);

    /*******
     * 获取当前数据字典类型的下一个序号
     * @param dictCode 字典编码
     * @return
     */
    Long getNextOrderNoByDictCode(String dictCode);

    /******
     * 获取数据字典总数
     * @param subSysId 子系统Id
     * @return
     */
    Integer getDictCountBySubSysId(String subSysId);

    /*****
     * 修改数据字典状态
     * @param ids 主键Id集合
     * @param user
     */
    void modifyStatusDataByIds(String ids, SysUser user);
}
