package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDept;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysDeptService
 * @author chris
 * @description 部门服务层接口类接口
 * @version 1.0
 * @date 2019-12-23 19:30
 */
public interface SysDeptService {

    /****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<SysDept> page(Page<SysDept> page, SysDept entity);

    /*****
     * 保存部门数据
     * @param entity
     * @param isCreate
     * @param user 当前登录用户
     */
    void saveOrUpdate(SysDept entity, boolean isCreate, SysUser user);

    /*****
     * 获取部门信息
     * @param id 主键ID
     * @return
     */
    SysDept getEntityInfoById(String id);

    /*****
     * 删除部门信息
     * @param ids id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /****
     * 获取部门下拉框信息
     * @param orgId
     * @param filter
     * @return
     */
    List<ComboboxVo> queryEntityCombobox(String orgId, String filter);

    /*******
     * 获取组织机构下部门总数
     * @param orgId
     * @return
     */
    Integer getSysDeptCountByOrgId(String orgId);

    /**
     * 根据机构id获取部门信息
     *
     * @param orgId 机构id
     * @return
     */
    List<SysDept> getEntityDataListByOrgId(String orgId);

    /*******
     * 获取当前部门的下一个序号
     * @param orgId 组织机构Id
     * @return
     */
    Integer getDeptNextOrderNoByOrgId(String orgId);
}
