package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.kdgcsoft.jt.xzzf.common.component.AppMenuVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;
import java.util.Map;

/****
 * @className SysAppUserMenuService
 * @author chris
 * @description App用户菜单服务层接口接口
 * @version 1.0
 * @date 2020-04-30 09:36
 */
public interface SysAppUserMenuService {

    /******
     * 获取App用户所有系统菜单信息
     * @param userId 用户Id
     * @param filter 关键字过滤
     * @return
     */
    Map<String, Object> queryAppUserMenuInfo(String userId, String filter);

    /******
     * 保存App用户菜单信息
     * @param userId 当前App登录用户
     * @param menuIds App菜单Id集合
     * @param user 当前App登录用户
     */
    void saveOrUpdate(String userId, String menuIds, SysUser user);

    /******
     * 获取App用户自定义的菜单
     * @param userId 用户Id
     * @param subSysId 所属子系统
     * @param filter 关键字过滤
     * @return
     */
    List<AppMenuVo> queryAppCustomMenuByUserIdAndSubSysId(String userId, String subSysId, String filter);
}
