package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysZywj
 * @author ChrisYolanda
 * @description 系统资源文件
 * @version 1.0
 * @date 2020-12-07 18:35
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_ZYWJ")
public class SysZywj extends BaseEntity<String> {

    /**
     * 资源文件表主键ID
     */
    @TableId
    private String zywjId;

    /*****
     * 资源文件标题
     */
    private String zywjTitle;

    /*****
     * 资源文件名称
     */
    private String zywjName;

    /*****
     * 资源文件编码
     */
    private String zywjCode;

    /*****
     * 资源文件描述
     */
    private String zywjDes;

    /*****
     * 资源文件类型
     */
    private String zywjType;

    /*****
     * 资源文件类别
     */
    private String zywjCategory;

    /*****
     * 资源文件状态
     */
    private String zywjStatus;

    /*****
     * 资源文件下载地址
     */
    private String zywjFilePath;

    /*****
     * 资源文件二维码图片地址
     */
    private String zywjImgPath;

    /*****
     * 资源文件序号
     */
    private String sort;

    /*****
     * 资源文件备注
     */
    private String zywjBz;

    /*****
     * 资源文件状态对应的文本值
     */
    @TableField(exist = false)
    private String zywjStatusText;

    /*****
     * 资源文件类型对应的文本值
     */
    @TableField(exist = false)
    private String zywjTypeText;

    @Override
    public String getId() {
        return zywjId;
    }

    @Override
    public void setId(String id) {
        this.zywjId = id;
    }
}
