package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/****
 * @className SysZxyh
 * @author ChrisYolanda
 * @description 系统在线用户实体类
 * @version 1.0
 * @date 2020-11-22 10:41
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_ZXYH")
public class SysZxyh implements Serializable {

    /*****
     * 登录方式
     * 01-WEB端登录;
     * 02-移动执法APP登录;
     * 03-执法公示APP登录
     */
    public static final String USER_LOGIN_TYPE_01 = "01";
    public static final String USER_LOGIN_TYPE_02 = "02";
    public static final String USER_LOGIN_TYPE_03 = "03";

    /****
     * 统计时间
     */
    @TableField("SYSTIME")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date sysTime;

    /*****
     * 用户总数
     */
    @TableField("USERCOUNT")
    private Integer userCount;

    /*****
     * 登录方式
     * 01-WEB端登录;
     * 02-移动执法APP登录;
     * 03-执法公示APP登录
     */
    @TableField("LOGIN_TYPE")
    private String loginType;

    /******
     * 开始时间
     */
    @TableField(exist = false)
    private String startTime;

    /******
     * 结束时间
     */
    @TableField(exist = false)
    private String endTime;
}
