package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysXzqh
 * @author chris
 * @description 行政区划实体类
 * @version 1.0
 * @date 2020-03-30 10:38
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_C_XZQHDM")
public class SysXzqh extends BaseEntity<String> {

    /****
     * 行政区划根节点Id
     */
    public static final String XZQH_ROOT_ID = "0";

    /*****
     * 主键Id
     */
    @TableId
    private String xzqhId;

    /*****
     * 父级行政区划id
     */
    private String fjXzqhId;

    /*****
     * 行政区划编码
     */
    private String xzqhBh;

    /*****
     * 行政区划名称
     */
    private String xzqhMc;

    /*****
     * 行政区划等级
     */
    private String xzqhDj;

    /*****
     * 行政区划简称
     */
    private String xzqhJc;

    /*****
     * 排序
     */
    private String px;

    /*****
     * 备注
     */
    private String remarks;

    @Override
    public String getId() {
        return xzqhId;
    }

    @Override
    public void setId(String id) {
        this.xzqhId = id;
    }
}
