package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className SysUserRole
 * @author chris
 * @description 用户角色实体类
 * @version 1.0
 * @date 2019-12-27 13:28
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_USER_ROLE")
public class SysUserRole extends BaseEntity<String> {

    /****
     * 用户角色设置方式
     * 01-系统分配
     * 02-协同办案系统的领导分配
     * 03-协同办案系统的单位负责人分配
     */
    public static final String SYS_USER_ROLE_SET_TYPE_01 = "01";
    public static final String SYS_USER_ROLE_SET_TYPE_02 = "02";
    public static final String SYS_USER_ROLE_SET_TYPE_03 = "03";

    /*****
     * 用户角色表主键Id
     */
    @TableId
    private String userRoleId;

    /*****
     * 用户主键Id
     */
    private String userId;

    /*****
     * 角色主键Id
     */
    private String roleId;

    /****
     * 用户角色设置方式
     * 01-系统分配
     * 02-领导分配
     */
    private String sourceType;

    /****
     * 授权备注
     */
    private String authRemarks;

    /****
     * 解除授权备注
     */
    private String relieveRemarks;

    /****
     * 授权有效截止时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date authEndTime;

    /****
     * 授权用户Id
     */
    private String authUserId;

    /****
     * 解除授权用户Id
     */
    private String relieveUserId;

    /*****
     * 角色编码
     */
    @TableField(exist = false)
    private String roleCode;

    /*****
     * 角色名称
     */
    @TableField(exist = false)
    private String roleName;

    /*****
     * 子系统主键Id
     */
    @TableField(exist = false)
    private String subSysId;

    /****
     * 用户角色设置方式
     * 01-系统分配
     * 02-协同办案系统领导分配
     * 03-协同办案系统单位负责人分配
     */
    @TableField(exist = false)
    private String setSourceTypeText;

    /****
     * 授权人名称
     */
    @TableField(exist = false)
    private String authUserName;

    @Override
    public String getId() {
        return userRoleId;
    }

    @Override
    public void setId(String id) {
        this.userRoleId = id;
    }
}
