package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className SysUserDzqz
 * @author chris
 * @description 用户电子签章实体类
 * @version 1.0
 * @date 2020-06-17 21:22
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_USER_DZQZ")
public class SysUserDzqz extends BaseEntity<String> {

    /****
     * 授权方式
     * 01-本人授权
     * 02-管理员授权
     */
    public static final String SYS_USER_SIGN_AUTH_TYPE_01 = "01";
    public static final String SYS_USER_SIGN_AUTH_TYPE_02 = "02";

    /*****
     * 用户电子签章Id
     */
    @TableId
    private String userDzqzId;

    /*****
     * 用户Id
     */
    private String userId;

    /*****
     * 签章Id
     */
    private String dzqzId;

    /*****
     * 签章号
     */
    private String qianZhangHao;

    /*****
     * 签章类别
     */
    private String qianZhangLeiBie;

    /*****
     * 创建人用户Id
     */
    private String createrUserId;

    /*****
     * 创建人所属组织机构Id
     */
    private String createrOrgId;

    /****
     * 授权方式
     * 01-本人授权
     * 02-管理员授权
     */
    private String sourceType;

    /****
     * 授权备注
     */
    private String authRemarks;

    /****
     * 解除授权备注
     */
    private String relieveRemarks;

    /****
     * 授权有效截止时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date authEndTime;

    /*****
     * 签章类别Text
     */
    @TableField(exist = false)
    private String qianZhangLeiBieText;

    /*****
     * 签章所属组织机构名称
     */
    @TableField(exist = false)
    private String orgName;

    /*****
     * 签章名称
     */
    @TableField(exist = false)
    private String xingMing;

    /*****
     * 被授权人账号
     */
    @TableField(exist = false)
    private String signUserAct;

    /*****
     * 被授权人名称
     */
    @TableField(exist = false)
    private String signUserName;

    /*****
     * 被授权人执法证号
     */
    @TableField(exist = false)
    private String signUserZfzh;

    /*****
     * 被授权人性别
     */
    @TableField(exist = false)
    private String signUserSex;

    /*****
     * 被授权人手机号
     */
    @TableField(exist = false)
    private String signUserTel;

    /*****
     * 被授权人性别Text
     */
    @TableField(exist = false)
    private String signUserSexText;

    /*****
     * 被授权人所属组织机构Id
     */
    @TableField(exist = false)
    private String signUserOrgId;

    /*****
     * 被授权人所属组织机构名称
     */
    @TableField(exist = false)
    private String signUserOrgName;

    /*****
     * 授权人名称
     */
    @TableField(exist = false)
    private String createrUserName;

    /*****
     * 授权人组织机构名称
     */
    @TableField(exist = false)
    private String createrOrgName;

    /*****
     * 签章拥有人执法证号
     */
    @TableField(exist = false)
    private String zhiFaZhengHao;

    /*****
     * 签章密码
     */
    @TableField(exist = false)
    private String qianZhangMiMa;

    /*****
     * 签章类别数组
     */
    @TableField(exist = false)
    private String[] qzTypeArr;

    @Override
    public String getId() {
        return userDzqzId;
    }

    @Override
    public void setId(String id) {
        this.userDzqzId = id;
    }
}
