package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;
import java.util.Map;

/****
 * @className SysUser
 * @author chris
 * @description 用户实体类
 * @version 1.0
 * @date 2019-12-24 11:03
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_USER")
public class SysUser extends BaseEntity<String> {

    /*****
     * 子系统特殊角色
     * 01-普通用户(适用于所有系统)
     * 02-超管或单位管理员角色(仅适用于基础管理系统)
     * 03-领导角色(仅适用于协同办案系统)
     * 04-仅有全省执法人员角色(仅适用于执法人员系统)
     * 05-包含全省执法人员角色(仅适用于执法人员系统)
     * 06-案件审批角色(仅适用于协同办案系统的单位负责人角色)
     */
    public static final String SUB_SYS_SPEC_ROLE_01 = "01";
    public static final String SUB_SYS_SPEC_ROLE_JCGL_02 = "02";
    public static final String SUB_SYS_SPEC_ROLE_XTBA_03 = "03";
    public static final String SUB_SYS_SPEC_ROLE_ZFRY_04 = "04";
    public static final String SUB_SYS_SPEC_ROLE_ZFRY_05 = "05";
    public static final String SUB_SYS_SPEC_ROLE_XTBA_06 = "06";

    /****
     * 用户ID
     */
    @TableId
    private String userId;

    /****
     * 用户账号
     */
    @NotNull(message = "用户账号不能为空")
    private String userName;

    /****
     * 密码
     */
    @JsonIgnore
    private String userPwd;

    /****
     * 真实姓名
     */
    private String name;

    /****
     * 机构ID
     */
    private String orgId;

    /****
     * 登录状态
     */
    private String loginStatus;

    /****
     * 密码错误次数
     */
    private Integer pwdWrongNum;

    /****
     * 登录次数
     */
    private Integer loginNum;

    /****
     * 登录IP
     */
    private String loginIp;

    /****
     * 性别
     */
    private String sex;

    /****
     * 电话
     */
    private String tel;

    /****
     * 联系方式
     */
    private String contact;

    /****
     * 邮件
     */
    @Email(message = "邮箱格式不正确")
    private String email;

    /****
     * 部门ID
     */
    private String deptId;

    /****
     * 身份证号
     */
    private String idCard;

    /****
     * 用户类型
     */
    private String userType;

    /****
     * 牌子ID
     */
    private String signId;

    /****
     * 是否超级管理员
     */
    private String superAdmin;

    /****
     * 执法人员主键Id
     */
    private String zfryid;

    /****
     * 执法人员的执法证号
     */
    private String zfzh;

    /****
     * 是否运维人员
     */
    private String ywrybm;

    /****
     * 是否为初始密码状态
     */
    private String csmmzt;

    /****
     * 用户状态:01-正常,02-禁用,03-锁定
     */
    private String userStatus;

    /****
     * 备注
     */
    private String bz;

    /****
     * app用户登录后的token
     */
    private String appToken;

    /****
     * 行政区划Id
     */
    @TableField("XZQHID")
    private String xzqhId;

    /****
     * 组织机构名称
     */
    @TableField(exist = false)
    private String orgName;

    /****
     * 部门名称
     */
    @TableField(exist = false)
    private String deptName;

    /****
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhName;

    /****
     * 单位级别
     */
    @TableField(exist = false)
    private String orgLevel;

    /****
     * 单位编码
     */
    @TableField(exist = false)
    private String orgCode;

    /****
     * 单位级别Text
     */
    @TableField(exist = false)
    private String orgLevelText;

    /****
     * 单位电话
     */
    @TableField(exist = false)
    private String orgTel;

    /****
     * 单位地址
     */
    @TableField(exist = false)
    private String orgAddr;

    /****
     * 单位联系人
     */
    @TableField(exist = false)
    private String orgManager;

    /****
     * 性别Text
     */
    @TableField(exist = false)
    private String sexText;

    /****
     * 是否超级管理员Text
     */
    @TableField(exist = false)
    private String superAdminText;

    /****
     * 是否运维人员Text
     */
    @TableField(exist = false)
    private String ywrybmText;

    /****
     * 用户状态Text
     */
    @TableField(exist = false)
    private String userStatusText;

    /****
     * 邮编
     */
    @TableField(exist = false)
    private String orgZip;

    /*****
     * 原密码
     */
    @TableField(exist = false)
    private String oldPwd;

    /*****
     * 新密码
     */
    @TableField(exist = false)
    private String newPwd;

    /*****
     * 确认密码
     */
    @TableField(exist = false)
    private String confirmPwd;

    /****
     * 是否独立执法主体
     */
    @TableField(exist = false)
    private String dlzfzt;

    /*****
     * 角色Id
     */
    @TableField(exist = false)
    private String roleId;

    /*****
     * 角色Ids
     */
    @TableField(exist = false)
    private String roleIds;

    /*****
     * 忽略的用户账号
     */
    @TableField(exist = false)
    private String[] ignoreUserName;

    /*****
     * 忽略的用户信息
     */
    @TableField(exist = false)
    private String[] ignoreUserInfo;

    /****
     * 资金归属地
     */
    @TableField(exist = false)
    private String capitalOwnerId;

    /****
     * 执收单位编码
     */
    @TableField(exist = false)
    private String imposeDeptCode;

    /****
     * 执收单位名称
     */
    @TableField(exist = false)
    private String imposeDeptName;

    /****
     * 行政区划详细地址
     */
    @TableField(exist = false)
    private String xzqhFullName;

    /****
     * 电子签章Id
     */
    @TableField(exist = false)
    private String dzqzId;

    /****
     * 签章名称
     */
    @TableField(exist = false)
    private String signName;

    /****
     * 签章图片名称
     */
    @TableField(exist = false)
    private String signTpName;

    /****
     * 签章路径
     */
    @TableField(exist = false)
    private String signPath;

    /****
     * 案处机构id
     */
    @TableField(exist = false)
    private String orgDealId;

    /****
     * 父节点Id
     */
    @TableField(exist = false)
    private String orgPid;

    /****
     * 执法人员分机号信息
     */
    @TableField(exist = false)
    private List<ComboboxVo> peerInfo;

    /*****
     * 子系统特殊角色
     * 01-普通用户(适用于所有系统)
     * 02-超管或单位管理员角色(仅适用于基础管理系统)
     * 03-领导角色(仅适用于协同办案系统)
     * 04-仅有全省执法人员角色(仅适用于执法人员系统)
     * 05-包含全省执法人员角色(仅适用于执法人员系统)
     * 06-案件注销审批角色(仅适用于协同办案系统的单位负责人角色)
     */
    @TableField(exist = false)
    private List<Map<String, Object>> subSysSpecRole;

    /****
     * 发证机构名称
     */
    @TableField(exist = false)
    private String fyjgMc;

    /****
     * 人民法院名称
     */
    @TableField(exist = false)
    private String rmfyMc;

    /****
     * 特殊角色授权到期时间
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    @TableField(exist = false)
    private Date specRoleAuthEndTime;

    /*****
     * 文书送达机构Id
     */
    @TableField(exist = false)
    private String orgDocId;

    @Override
    public String getId() {
        return userId;
    }

    @Override
    public void setId(String id) {
        this.userId = id;
    }
}
