package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className SysSuggestHis
 * @author chris
 * @description 问题反馈历史记录实体类
 * @version 1.0
 * @date 2020-07-08 20:40
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_SUGGEST_HIS")
public class SysSuggestHis extends BaseEntity<String> {

    /****
     * 问题反馈历史记录表主键ID
     */
    @TableId
    private String hisId;

    /****
     * 问题反馈表主键ID
     */
    private String suggestId;

    /****
     * 用户主键Id
     */
    private String userId;

    /****
     * 用户账号
     */
    private String userAct;

    /****
     * 用户名称
     */
    private String userName;

    /****
     * 时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date sj;

    /****
     * 内容
     */
    private String nr;

    /****
     * 状态
     */
    private String zt;

    /****
     * 状态Text
     */
    @TableField(exist = false)
    private String ztText;

    /****
     * 反馈信息标题
     */
    @TableField(exist = false)
    private String title;

    /****
     * 用户Tel
     */
    @TableField(exist = false)
    private String userTel;

    /****
     * 组织机构名称
     */
    @TableField(exist = false)
    private String orgName;

    /****
     * 是否运维人员
     */
    @TableField(exist = false)
    private String ywrybm;

    @Override
    public String getId() {
        return hisId;
    }

    @Override
    public void setId(String id) {
        this.hisId = id;
    }
}
