package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className SysSuggest
 * @author chris
 * @description 问题反馈实体类
 * @version 1.0
 * @date 2020-07-08 20:39
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_SUGGEST")
public class SysSuggest extends BaseEntity<String> {

    /****
     * 问题反馈操作类型
     * 1-修改,
     * 2-回复,
     * 3-追问,
     * 4-确认,
     * 5-删除
     */
    public static final String OPT_TYPE_1 = "1";
    public static final String OPT_TYPE_2 = "2";
    public static final String OPT_TYPE_3 = "3";
    public static final String OPT_TYPE_4 = "4";
    public static final String OPT_TYPE_5 = "5";

    /**
     * 问题反馈表主键ID
     */
    @TableId
    private String suggestId;

    /**
     * 提出人主键Id
     */
    private String tcrid;

    /**
     * 提出人账号
     */
    private String tcrzh;

    /**
     * 提出人姓名
     */
    private String tcrmc;

    /**
     * 提出时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date tcsj;

    /**
     * 所属单位Id
     */
    private String ssdwid;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 子系统Id
     */
    private String subSysId;

    /**
     * 联系电话
     */
    private String lxdh;

    /**
     * QQ号码
     */
    private String qqhm;

    /**
     * 微信号码
     */
    private String wxhm;

    /**
     * 问题分类编码
     */
    private String wtflbm;

    /**
     * 问题状态
     */
    private String wtzt;

    /**
     * 问题标题
     */
    private String wtbt;

    /**
     * 问题描述
     */
    private String wtms;

    /*****
     * 子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    /*****
     * 问题分类编码Text
     */
    @TableField(exist = false)
    private String wtflbmText;

    /*****
     * 问题状态Text
     */
    @TableField(exist = false)
    private String wtztText;

    /*****
     * 所属单位名称
     */
    @TableField(exist = false)
    private String ssdwName;

    /*****
     * 系统负责人
     */
    @TableField(exist = false)
    private String sysCharge;


    /******
     * 系统负责人手机号
     */
    @TableField(exist = false)
    private String sysChargeMobile;

    @Override
    public String getId() {
        return suggestId;
    }

    @Override
    public void setId(String id) {
        this.suggestId = id;
    }
}
