package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysSubSystem
 * @author chris
 * @description 子系统实体类
 * @version 1.0
 * @date 2019-12-24 11:03
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_SUB_SYSTEM")
public class SysSubSystem extends BaseEntity<String> {

    /*****
     * 子系统表主键ID
     */
    @TableId
    private String systemId;

    /****
     * 子系统名称
     */
    private String name;

    /****
     * 子系统简称
     */
    private String simpleName;

    /****
     * 子系统URL
     */
    private String url;

    /****
     * 子系统图标样式
     */
    private String systemIcon;

    /****
     * 子系统编码
     */
    private String systemCode;

    /****
     * 子系统状态
     */
    private String enable;

    /****
     * 子系统排序
     */
    private Integer sort;

    /******
     * 系统Logo名称
     */
    private String systemLogoName;

    /******
     * 系统Svg名称
     */
    private String systemSvgName;

    /******
     * 系统负责人
     */
    private String sysCharge;

    /******
     * 系统负责人手机号
     */
    private String sysChargeMobile;

    /****
     * 备注
     */
    private String remarks;

    /*****
     * 子系统状态对应的文本值
     */
    @TableField(exist = false)
    private String enableText;

    @Override
    public String getId() {
        return systemId;
    }

    @Override
    public void setId(String id) {
        this.systemId = id;
    }
}
