package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className SysSms
 * @author chris
 * @description 短信息实体类
 * @version 1.0
 * @date 2021-12-24 20:05
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_SMS")
public class SysSms extends BaseEntity<String> {
    /**
     * 短信ID
     */
    @TableId
    private String smsId;

    /*****
     * 短信息关键字
     */
    private String smsKey;

    /*****
     * 短信息类别
     */
    private String smsType;

    /*****
     * 接收人号码
     */
    private String smsCode;

    /******
     * 接收信息内容
     */
    private String smsContent;

    /****
     * 发送时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date smsSendTime;

    /*****
     * 短信息类别Text
     */
    @TableField(exist = false)
    private String smsTypeText;

    @Override
    public String getId() {
        return smsId;
    }

    @Override
    public void setId(String id) {
        this.smsId = id;
    }
}
