package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysRoleMenu
 * @author chris
 * @description 角色菜单实体类
 * @version 1.0
 * @date 2019-12-27 11:40
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_ROLE_MENU")
public class SysRoleMenu extends BaseEntity<String> {

    /*****
     * 角色菜单表主键Id
     */
    @TableId
    private String roleMenuId;

    /*****
     * 角色主键Id
     */
    private String roleId;

    /*****
     * 菜单主键Id
     */
    private String menuId;

    /*****
     * 菜单编码
     */
    @TableField(exist = false)
    private String menuCode;

    /*****
     * 菜单名称
     */
    @TableField(exist = false)
    private String menuName;

    /*****
     * 所属子系统主键Id
     */
    @TableField(exist = false)
    private String subSysId;

    /*****
     * 所属子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    /*****
     * 角色编码
     */
    @TableField(exist = false)
    private String roleCode;

    /*****
     * 角色名称
     */
    @TableField(exist = false)
    private String roleName;

    @Override
    public String getId() {
        return roleMenuId;
    }

    @Override
    public void setId(String id) {
        this.roleMenuId = id;
    }
}
