package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysRole
 * @author chris
 * @description 角色实体类
 * @version 1.0
 * @date 2020-04-30 09:32
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_ROLE")
public class SysRole extends BaseEntity<String> {

    /****
     * 角色类别
     * 01-普通角色
     * 02-协同办案系统领导角色
     * 03-基础管理系统单位负责人角色
     * 04-执法人员系统全省执法人员角色
     * 05-协同办案系统案件审批角色
     */
    public static final String SYS_ROLE_CATEGORY_01 = "01";
    public static final String SYS_ROLE_CATEGORY_02 = "02";
    public static final String SYS_ROLE_CATEGORY_03 = "03";
    public static final String SYS_ROLE_CATEGORY_04 = "04";
    public static final String SYS_ROLE_CATEGORY_05 = "05";

    /****
     * 存在互斥角色信息
     * 01-存在
     * 02-不存在
     */
    public static final String SYS_ROLE_EXIST_MUTEX_01 = "01";
    public static final String SYS_ROLE_EXIST_MUTEX_02 = "02";

    /**
     * 角色ID
     */
    @TableId
    private String roleId;

    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 角色编码
     */
    private String roleCode;

    /**
     * 角色级别
     */
    private String roleLevel;

    /**
     * 角色类型
     */
    private String roleType;

    /**
     * 所属行业
     */
    private String roleHy;

    /**
     * 备注
     */
    private String remark;

    /**
     * 机构ID
     */
    private String orgId;

    /****
     * 子系统Id
     */
    private String subSysId;

    /**
     * 角色类型-省级
     */
    private String roleTypeProvince;

    /**
     * 角色类型-市级
     */
    private String roleTypeCity;

    /**
     * 角色类型-区/县级
     */
    private String roleTypeCounty;

    /**
     * 是否默认角色
     * 1-是
     * 0-否
     */
    private String defRole;

    /****
     * 角色类别
     * 01-普通角色
     * 02-基础管理系统单位负责人角色
     * 03-执法人员系统全省执法人员角色
     * 04-协同办案系统经办机构负责人角色
     * 05-协同办案系统单位负责人角色
     * 06-协同办案系统单位法制机构审核人角色
     * 07-协同办案系统案件注销审批人员角色
     */
    private String roleCategory;

    /*****
     * 用户主键Id
     */
    @TableField(exist = false)
    private String userId;

    /*****
     * 是否选中
     */
    @TableField(exist = false)
    private boolean checked = false;

    /*****
     * 子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    /*****
     * 子系统编码
     */
    @TableField(exist = false)
    private String subSysCode;

    /*****
     * 子系统序号
     */
    @TableField(exist = false)
    private String subSysSort;

    /**
     * 角色级别Text
     */
    @TableField(exist = false)
    private String roleLevelText;

    /**
     * 角色类型Text
     */
    @TableField(exist = false)
    private String roleTypeText;

    /**
     * 角色类型-省级Text
     */
    @TableField(exist = false)
    private String roleTypeProvinceText;

    /**
     * 角色类型-市级Text
     */
    @TableField(exist = false)
    private String roleTypeCityText;

    /**
     * 角色类型-区/县级Text
     */
    @TableField(exist = false)
    private String roleTypeCountyText;

    /**
     * 角色类别Text
     */
    @TableField(exist = false)
    private String roleCategoryText;

    /**
     * 完整的角色编码
     */
    @TableField(exist = false)
    private String roleFullCode;

    /**
     * 缩略的角色编码
     */
    @TableField(exist = false)
    private String roleShortCode;

    /****
     * 用户角色设置方式
     * 01-系统分配
     * 02-领导分配
     */
    @TableField(exist = false)
    private String sourceType;

    /****
     * 存在互斥角色信息
     * 01-存在
     * 02-不存在
     */
    @TableField(exist = false)
    private String existMutex;

    /****
     * 授权操作的用户的名称
     */
    @TableField(exist = false)
    private String authUserName;

    /****
     *解除授权操作的用户的名称
     */
    @TableField(exist = false)
    private String relieveUserName;

    @Override
    public String getId() {
        return roleId;
    }

    @Override
    public void setId(String id) {
        this.roleId = id;
    }
}
