package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;


/****
 * @className SysOrg
 * @author chris
 * @description 组织机构实体类
 * @version 1.0
 * @date 2019-12-20 17:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_ORG")
public class SysOrg extends BaseEntity<String> {
    /****
     * 组织机构根节点Id
     */
    public static final String ORG_ROOT_ID = "0";

    /****
     * 组织机构操作类型
     * 1-设置案件编号,
     * 2-设置财政归属,
     * 3-设置案件处理机构
     */
    public static final String OPT_TYPE_1 = "1";
    public static final String OPT_TYPE_2 = "2";
    public static final String OPT_TYPE_3 = "3";

    /*****
     * 组织机构表主键ID
     */
    @TableId
    private String orgId;

    /****
     * 父级ID
     */
    private String orgPid;

    /*****
     * 业务机构Id
     */
    private String orgBusinessId;

    /*****
     * 文书送达机构Id
     */
    private String orgDocId;

    /*****
     * 案件处理机构Id
     */
    private String orgDealId;

    /*****
     * 行政区划Id
     */
    private String xzqhId;

    /****
     * 机构等级类型
     */
    private String orgLevel;

    /****
     * 机构编码
     */
    private String orgCode;

    /****
     * 机构名称
     */
    private String orgName;

    /****
     * 机构简称
     */
    private String orgShortName;

    /****
     * 统一社会信用代码
     */
    private String orgCard;

    /****
     * 机构地址
     */
    private String orgAddr;

    /****
     * 机构网址
     */
    private String orgWeb;

    /****
     * 机构邮编
     */
    private String orgZip;

    /****
     * 联系电话
     */
    private String tel;

    /****
     * 电子邮箱
     */
    private String email;

    /****
     * 排序
     */
    private String sort;

    /****
     * 备注
     */
    private String remarks;

    /****
     * 案件编号起始值
     */
    private String orgCaseCode;

    /****
     * 独立执法主体
     */
    private String dlzfzt;

    /****
     * 组织机构联系人
     */
    private String orgManager;

    /****
     * 资金归属地
     */
    private String capitalOwnerId;

    /****
     * 执收单位编码
     */
    private String imposeDeptCode;

    /****
     * 执收单位名称
     */
    private String imposeDeptName;

    /****
     * 复议机构名称
     */
    private String fyjgmc;

    /****
     * 人民法院名称
     */
    private String rmfymc;

    /****
     * 发函类型
     */
    private String fhlx;

    /****
     * 是否是远程异地执法机构(0:否 1是)
     */
    private String isYcydzf;

    /*****
     * 父级机构名称
     */
    @TableField(exist = false)
    private String orgParName;

    /*****
     * 业务机构名称
     */
    @TableField(exist = false)
    private String orgBusinessName;

    /*****
     * 文书送达机构名称
     */
    @TableField(exist = false)
    private String orgDocName;

    /*****
     * 按出机构名称
     */
    @TableField(exist = false)
    private String orgDealName;

    /*****
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhName;

    /*****
     * 组织机构类型Text
     */
    @TableField(exist = false)
    private String orgLevelText;

    /*****
     * 独立执法主体Text
     */
    @TableField(exist = false)
    private String dlzfztText;

    /*****
     * 资金归属地Text
     */
    @TableField(exist = false)
    private String capitalOwnerText;

    /*****
     * 父级发文机关带字
     */
    @TableField(exist = false)
    private String parOrgShortName;

    @Override
    public String getId() {
        return orgId;
    }

    @Override
    public void setId(String id) {
        this.orgId = id;
    }
}
