package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/****
 * @className SysNotice
 * @author chris
 * @description 系统公告实体类
 * @version 1.0
 * @date 2020-07-12 20:08
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_NOTICE")
public class SysNotice extends BaseEntity<String> {

    /****
     * 公告Id
     */
    @TableId("NOTICE_ID")
    private String noticeId;

    /****
     * 公告标题
     */
    private String title;

    /****
     * 公告内容
     */
    private String contents;

    /****
     * 发布人Id
     */
    private String fbrid;

    /****
     * 发布人名称
     */
    private String fbrmc;

    /****
     * 发布单位Id
     */
    private String fbdwid;

    /****
     * 发布单位名称
     */
    private String fbdwmc;

    /****
     * 发布时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date fbsj;

    /****
     * 接收单位Id集合
     */
    @TableField(exist = false)
    private String jsdwIds;

    /****
     * 接收单位Id集合
     */
    @TableField(exist = false)
    private List<String> jsdwIdList;

    /****
     * 接收单位名称集合
     */
    @TableField(exist = false)
    private List<String> jsdwmcList;

    @Override
    public String getId() {
        return noticeId;
    }

    @Override
    public void setId(String id) {
        this.noticeId = id;
    }
}
