package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/****
 * @className SysMenu
 * @author chris
 * @description 菜单实体类
 * @version 1.0
 * @date 2020-04-30 09:32
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_MENU")
public class SysMenu extends BaseEntity<String> {

    /**
     * 菜单ID 主键字段
     */
    @TableId
    private String menuId;

    /**
     * 父菜单ID
     */
    private String menuPid;

    /**
     * 菜单名称
     */
    @NotNull(message = "菜单名称不能为空")
    private String menuName;

    /**
     * 菜单编码
     */
    @NotNull(message = "菜单编码不能为空")
    private String menuCode;

    /**
     * 页面对应的前台页面地址
     */
    private String menuPath;

    /**
     * 菜单URL
     */
    private String menuRedirect;

    /**
     * 类型 0：菜单  1：按钮
     */
    private String menuType;

    /**
     * 图标
     */
    private String menuIcon;

    /**
     * 顺序
     */
    private Integer menuOrder;

    /**
     * 状态  1:启用 0:禁用
     */
    private String menuState;

    /****
     * 子系统Id
     */
    private String subSysId;

    /**
     * 菜单显示
     */
    private String menuShow;

    /**
     * 按钮类型:1-工具栏按钮,2-列操作栏按钮
     */
    private String buttonType;

    /**
     * 菜单信息是否在APP上显示:1-显示,0-隐藏
     */
    private String menuAppShow;

    /**
     * 菜单在APP上的请求地址信息
     */
    private String menuAppPath;

    /**
     * 菜单在APP上对应的图标名称
     */
    private String menuAppIconName;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 页签编码
     */
    private String tabCode;

    /**
     * 页签是否需要缓存
     * 是(1):页签只在首次加载时刷新;
     * 否(0):每次进入此页签都会刷新当前页签信息
     */
    private String tabAttr;

    /******
     * 菜单信息是否在APP上固定
     * 0-不固定
     * 1-固定
     */
    private String menuAppFixed;

    /**
     * 列操作按钮
     */
    @TableField(exist = false)
    private List<String> colButtons = new ArrayList<>();

    /**
     * 工具栏按钮
     */
    @TableField(exist = false)
    private List<String> toolButtons = new ArrayList<>();

    /****
     * 子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    /****
     * 父级菜单名称
     */
    @TableField(exist = false)
    private String menuParName;

    /*****
     * 菜单类型对应的文本值
     */
    @TableField(exist = false)
    private String menuTypeText;

    /*****
     * 菜单显示对应的文本值
     */
    @TableField(exist = false)
    private String menuShowText;

    /*****
     * 按钮类型对应的文本值
     */
    @TableField(exist = false)
    private String buttonTypeText;

    /*****
     * 菜单状态对应的文本值
     */
    @TableField(exist = false)
    private String menuStateText;

    /*****
     * 菜单信息是否在APP上显示对应的文本值
     */
    @TableField(exist = false)
    private String menuAppShowText;

    /*****
     * 页签缓存文本值
     */
    @TableField(exist = false)
    private String tabAttrText;

    /*****
     * 是否选中
     */
    @TableField(exist = false)
    private boolean checked;

    /**
     * 菜单显示
     */
    @TableField(exist = false)
    private String hidden;


    @Override
    public String getId() {
        return menuId;
    }

    @Override
    public void setId(String id) {
        this.menuId = id;
    }
}
