package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysDzqztp
 * @author chris
 * @description 电子签章图片实体类
 * @version 1.0
 * @date 2020-06-17 21:39
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_J_DZQZTP")
public class SysDzqztp extends BaseEntity<String> {

    /******
     * 主键Id
     */
    @TableId
    private String zhuJianId;

    /*****
     * 签章号
     */
    private String qianZhangHao;

    /*****
     * 对接账号
     */
    private String duiJieZhangHao;

    /*****
     * 签章密码
     */
    private String qianZhangMiMa;

    /*****
     * 签章名称
     */
    private String xingMing;

    /*****
     * 执法证号
     */
    private String zhiFaZhengHao;

    /*****
     * 图片名称
     */
    private String tuPianMingCheng;

    /*****
     * 图片地址
     */
    private String tuPianDiZhi;

    /*****
     * 图片公共路径
     */
    private String tuPianPubLuJing;

    /*****
     * 签章类别
     */
    private String qianZhangLeiBie;

    /*****
     * 签章用途
     */
    private String qianZhangYongTu;

    /*****
     * 备注
     */
    private String rowVersion;

    /*****
     * 用户Id
     */
    private String userId;

    /*****
     * 组织机构Id
     */
    private String orgId;

    /*****
     * 证书路径
     */
    private String certPath;
    /*****
     * 先安电子签章id
     */
    private String stampId;
    /*****
     * 先安电子签章证书公钥
     */
    private String cert;
    /*****
     * 先安电子签章证书私钥
     */
    private String privateKey;
    /*****
     * 先安电子签章证书指纹
     */
    private String fingerPrint;

    /*****
     * 签章类别Text
     */
    @TableField(exist = false)
    private String qianZhangLeiBieText;

    /*****
     * 签章用途Text
     */
    @TableField(exist = false)
    private String qianZhangYongTuText;

    /*****
     * 签章id
     */
    @TableField(exist = false)
    private String dzqzId;

    /*****
     * 签章id
     */
    @TableField(exist = false)
    private String signId;

    /*****
     * 用户账号
     */
    @TableField(exist = false)
    private String userAct;

    /*****
     * 用户名称
     */
    @TableField(exist = false)
    private String userName;

    /*****
     * 组织机构名称
     */
    @TableField(exist = false)
    private String orgName;

    /*****
     * 被授权人主键Id
     */
    @TableField(exist = false)
    private String authUserId;

    /*****
     * 授权人名称
     */
    @TableField(exist = false)
    private String createrUserName;

    /*****
     * 授权人组织机构名称
     */
    @TableField(exist = false)
    private String createrOrgName;

    /*****
     * 原密码
     */
    @TableField(exist = false)
    private String oldPwd;

    /*****
     * 新密码
     */
    @TableField(exist = false)
    private String newPwd;

    /*****
     * 确认密码
     */
    @TableField(exist = false)
    private String confirmPwd;

    /*****
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;
    /*****
     * 身份证号
     */
    @TableField(exist = false)
    private String idCard;
    /*****
     * 签章状态（先安电子签章系统）
     */
    @TableField(exist = false)
    private String stampType;

    @Override
    public String getId() {
        return this.zhuJianId;
    }

    @Override
    public void setId(String id) {
        this.zhuJianId = id;
        this.dzqzId = this.zhuJianId;
        this.signId = this.zhuJianId;
    }
}
