package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotNull;


/****
 * @className SysDic
 * @author chris
 * @description 数据字典实体类
 * @version 1.0
 * @date 2020-04-30 09:32
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_DIC")
public class SysDic extends BaseEntity<String> {

    /******
     * 主键Id
     */
    @TableId
    private String dicId;

    /**
     * 字典编码
     */
    @NotNull(message = "字典编码不能为空")
    private String dicCode;

    /**
     * 字典名称
     */
    @NotNull(message = "字典名称不能为空")
    private String dicName;

    /**
     * 字典类别
     */
    private Long dicType;

    /**
     * 字典文字
     */
    private String dicText;

    /**
     * 字典值
     */
    private String dicValue;

    /**
     * 备注
     */
    private String memo;

    /**
     * 排序
     */
    private Long orderNo;

    /****
     * 子系统Id
     */
    private String subSysId;

    /****
     * 状态
     */
    private String status;

    /*****
     * 子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    /*****
     * 子系统编码
     */
    @TableField(exist = false)
    private String subSysCode;

    /*****
     * 完整的字典编码
     */
    @TableField(exist = false)
    private String dictFullCode;

    /*****
     * 字典编码缩写
     */
    @TableField(exist = false)
    private String dictShortCode;

    /****
     * 状态Text
     */
    @TableField(exist = false)
    private String statusText;

    @Override
    public String getId() {
        return dicId;
    }

    @Override
    public void setId(String id) {
        this.dicId = id;
    }


}
