package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysAppUserMenu
 * @author chris
 * @description App用户菜单实体类
 * @version 1.0
 * @date 2020-04-30 09:32
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_APP_USER_MENU")
public class SysAppUserMenu extends BaseEntity<String> {

    /*******
     * App用户菜单表主键
     */
    @TableId
    private String id;

    /******
     * 用户主键Id
     */
    @TableField("SYS_USER_ID")
    private String sysUserId;

    /******
     * 菜单主键Id
     */
    @TableField("SYS_MENU_ID")
    private String sysMenuId;

    /******
     * 排序
     */
    @TableField("SORT")
    private Integer sort;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
