package com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * app版本更新
 *
 * @author zd
 * @since 2020-07-02
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "SYS_APK_VERSION")
public class SysApkVersion {

    private static final long serialVersionUID = 1L;

    @TableId
    private String versionId;

    private Long code;

    private String msg;

    private Integer updateStatus;

    private String versionCode;

    /**
     * 版本名
     */
    private String versionName;

    /**
     * 版本更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 版本更新内容
     */
    private String modifyContent;

    /**
     * 下载地址
     */
    private String downloadUrl;

    private BigDecimal apkSize;

    private String apkMd5;

    /**
     * app类别
     */
    private String appType;


}
