package com.kdgcsoft.jt.xzzf.dubbo.system.log.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className OperateLog
 * @author chris
 * @description 操作日志实体类
 * @version 1.0
 * @date 2020-04-30 09:32
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "OPERATE_LOG")
public class OperateLog extends BaseEntity<String> {

    /****
     * 主键ID
     */
    @TableId
    private String id;

    /**
     * 模块
     */
    private String model;

    /**
     * 操作类型
     */
    private String type;

    /**
     * 描述
     */
    private String des;

    /****
     * 类名称
     */
    private String className;

    /**
     * 方法名称
     */
    private String method;

    /**
     * 方法参数
     */
    private String args;

    /**
     * 方法返回值
     */
    private String result;

    /**
     * 操作人
     */
    private String operateUser;

    /**
     * 操作时间
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date operateTime;

    /**
     * ip地址
     */
    private String ip;

    /**
     * 所属子系统主键Id
     */
    private String subSysId;

    /**
     * 所属子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    /**
     * 操作类型Text
     */
    @TableField(exist = false)
    private String typeText;

    /**
     * 操作人名称
     */
    @TableField(exist = false)
    private String operateUserName;

    /**
     * 用户账号
     */
    @TableField(exist = false)
    private String userAct;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
