package com.kdgcsoft.jt.xzzf.dubbo.system.log.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className LoginLog
 * @author chris
 * @description 登录日志实体类
 * @version 1.0
 * @date 2020-07-28 11:46
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "ERROR_LOG")
public class LoginLog extends BaseEntity<String> {

    /****
     * 主键ID
     */
    @TableId
    private String id;

    /**
     * 用户Id
     */
    private String userId;

    /**
     * 用户账号
     */
    private String userName;

    /**
     * 登录时间
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date loginTime;

    /**
     * ip地址
     */
    private String ip;

    /**
     * 使用的浏览器
     */
    private String browser;

    /**
     * 所属子系统主键Id
     */
    private String subSysId;

    /**
     * 所属子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    /**
     * 用户账号
     */
    @TableField(exist = false)
    private String userAct;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
