package com.kdgcsoft.jt.xzzf.dubbo.system.log.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ErrorLog
 * @author chris
 * @description 错误日志实体类
 * @version 1.0
 * @date 2020-07-28 11:42
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "ERROR_LOG")
public class ErrorLog extends BaseEntity<String> {

    /****
     * 主键ID
     */
    @TableId
    private String id;

    /****
     * 类名称
     */
    private String className;

    /****
     * 方法名称
     */
    private String method;

    /****
     * 方法参数
     */
    private String args;

    /****
     * 异常信息
     */
    private String errMsg;

    /**
     * 时间
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date time;

    /**
     * 用户Id
     */
    private String userId;

    /**
     * 所属子系统主键Id
     */
    private String subSysId;

    /**
     * 所属子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    /**
     * 用户名称
     */
    @TableField(exist = false)
    private String userName;

    /**
     * 用户账号
     */
    @TableField(exist = false)
    private String userAct;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
