package com.kdgcsoft.jt.xzzf.dubbo.system.constants;

import com.kdgcsoft.jt.xzzf.common.constant.DictConstants;

/****
 * @className DictConstant
 * @author chris
 * @description 数据字典常量配置类
 * @version 1.0
 * @date 2019-12-31 17:55
 */
public class DictConstant extends DictConstants {

    /******
     * 部门类型:DEPT_TYPE
     */
    public static final String DICT_CODE_DEPT_TYPE = "DEPT_TYPE";

    /******
     * 子系统类型:SYSTEM_TYPE
     */
    public static final String DICT_CODE_SYSTEM_TYPE = "SYSTEM_TYPE";

    /******
     * 所属模块:MODELS
     */
    public static final String DICT_CODE_MODEL_TYPE = "MODELS";

    /******
     * 操作类型:JCGL_OPERATE
     */
    public static final String DICT_CODE_JCGL_OPERATE_TYPE = "JCGL_OPERATE";

    /******
     * APP类型:JCGL_APP_CODE
     */
    public static final String DICT_CODE_JCGL_APP_CODE = "JCGL_APP_CODE";

    /******
     * 组织机构单位级别:ZZJGDWJB
     * 01:省厅
     * 02:省执法局
     * 03:市局
     * 04:市执法局（支队）
     * 05:县/区局
     * 06:县/区执法局（大队）
     * 07:基层站所/分局/高速路政大队
     */
    public static final String DICT_CODE_ZZJGDWJB_TYPE = "ZZJGDWJB";
    public static final String DICT_CODE_ZZJGDWJB_TYPE_01 = "01";
    public static final String DICT_CODE_ZZJGDWJB_TYPE_02 = "02";
    public static final String DICT_CODE_ZZJGDWJB_TYPE_03 = "03";
    public static final String DICT_CODE_ZZJGDWJB_TYPE_04 = "04";
    public static final String DICT_CODE_ZZJGDWJB_TYPE_05 = "05";
    public static final String DICT_CODE_ZZJGDWJB_TYPE_06 = "06";
    public static final String DICT_CODE_ZZJGDWJB_TYPE_07 = "07";

    /******
     * 角色级别:JSJB
     * 01:一级
     * 02:二级
     * 03:三级
     */
    public static final String DICT_CODE_JSJB_TYPE = "JSJB";
    public static final String DICT_CODE_JSJB_TYPE_1 = "01";
    public static final String DICT_CODE_JSJB_TYPE_2 = "02";
    public static final String DICT_CODE_JSJB_TYPE_3 = "03";

    /******
     * 菜单类型:MENU_TYPE
     * 0:菜单
     * 1:按钮
     */
    public static final String DICT_CODE_MENU_TYPE = "MENU_TYPE";
    public static final String DICT_CODE_MENU_TYPE_0 = "0";
    public static final String DICT_CODE_MENU_TYPE_1 = "1";

    /******
     * 按钮类型:BUTTON_TYPE
     * 1:工具栏按钮
     * 2:操作列按钮
     */
    public static final String DICT_CODE_BUTTON_TYPE = "BUTTON_TYPE";
    public static final String DICT_CODE_BUTTON_TYPE_1 = "1";
    public static final String DICT_CODE_BUTTON_TYPE_2 = "2";

    /******
     * 菜单状态:MENU_STATUS
     * 1:启用
     * 0:禁用
     */
    public static final String DICT_CODE_MENU_STATUS_TYPE = "MENU_STATUS";
    public static final String DICT_CODE_MENU_STATUS_1 = "1";
    public static final String DICT_CODE_MENU_STATUS_0 = "0";

    /*****
     * 签章类型:QIAN_ZHANG_TYPE
     * 01:私章
     * 02:公章
     */
    public static final String DICT_CODE_QIAN_ZHANG_TYPE = "QIAN_ZHANG_TYPE";
    public static final String DICT_CODE_QIAN_ZHANG_TYPE_01 = "01";
    public static final String DICT_CODE_QIAN_ZHANG_TYPE_02 = "02";

    /*****
     * 签章用途:JCGL_SIGN_CATEGORY
     * 01:通用
     * 02:许可
     * 03:处罚
     * 04:财政
     */
    public static final String DICT_CODE_JCGL_SIGN_CATEGORY = "JCGL_SIGN_CATEGORY";
    public static final String DICT_CODE_JCGL_SIGN_CATEGORY_01 = "01";
    public static final String DICT_CODE_JCGL_SIGN_CATEGORY_02 = "02";
    public static final String DICT_CODE_JCGL_SIGN_CATEGORY_03 = "03";
    public static final String DICT_CODE_JCGL_SIGN_CATEGORY_04 = "04";

    /*****
     * 问题分类编码:SYS_WTFLBM
     * 01:咨询
     * 02:建议
     * 03:反馈
     */
    public static final String DICT_CODE_SYS_WTFLBM = "SYS_WTFLBM";
    public static final String DICT_CODE_SYS_WTFLBM_01 = "01";
    public static final String DICT_CODE_SYS_WTFLBM_02 = "02";
    public static final String DICT_CODE_SYS_WTFLBM_03 = "03";

    /*****
     * 问题状态:SYS_WTZT
     * 01:未回复
     * 02:已回复
     * 03:再追问
     * 04:已解决
     */
    public static final String DICT_CODE_SYS_WTZT = "SYS_WTZT";
    public static final String DICT_CODE_SYS_WTZT_01 = "01";
    public static final String DICT_CODE_SYS_WTZT_02 = "02";
    public static final String DICT_CODE_SYS_WTZT_03 = "03";
    public static final String DICT_CODE_SYS_WTZT_04 = "04";

    /*****
     * 角色类型:JCGL_ROLE_TYPE
     * 01:省
     * 02:市
     * 03:区/县
     */
    public static final String DICT_CODE_JCGL_ROLE_TYPE = "JCGL_ROLE_TYPE";
    public static final String DICT_CODE_JCGL_ROLE_TYPE_01 = "01";
    public static final String DICT_CODE_JCGL_ROLE_TYPE_02 = "02";
    public static final String DICT_CODE_JCGL_ROLE_TYPE_03 = "03";

    /*****
     * 用户状态:JCGL_USER_STATUS
     * 01:正常
     * 02:禁用
     * 03:锁定
     */
    public static final String DICT_CODE_JCGL_USER_STATUS = "JCGL_USER_STATUS";
    public static final String DICT_CODE_JCGL_USER_STATUS_01 = "01";
    public static final String DICT_CODE_JCGL_USER_STATUS_02 = "02";
    public static final String DICT_CODE_JCGL_USER_STATUS_03 = "03";

    /****
     * 发函类型:SYS_ORG_FHLX
     * 01-默认类型
     * 02-超限发函
     */
    public static final String DICT_CODE_JCGL_ORG_FHLX = "JCGL_ORG_FHLX";
    public static final String DICT_CODE_JCGL_ORG_FHLX_01 = "01";
    public static final String DICT_CODE_JCGL_ORG_FHLX_02 = "02";

    /****
     * 文件类型:JCGL_FILE_TYPE
     * rar-rar压缩包
     * zip-zip压缩包
     * apk-apk安装包
     * docx-docx文档
     * doc-doc文档
     * xlsx-xlsx文件
     * xls-xls文件
     * pdf-pdf文件
     */
    public static final String DICT_CODE_JCGL_FILE_TYPE = "JCGL_FILE_TYPE";
    public static final String DICT_CODE_JCGL_FILE_TYPE_RAR = "rar";
    public static final String DICT_CODE_JCGL_FILE_TYPE_ZIP = "zip";
    public static final String DICT_CODE_JCGL_FILE_TYPE_APK = "apk";
    public static final String DICT_CODE_JCGL_FILE_TYPE_DOCX = "docx";
    public static final String DICT_CODE_JCGL_FILE_TYPE_DOC = "doc";
    public static final String DICT_CODE_JCGL_FILE_TYPE_XLSX = "xlsx";
    public static final String DICT_CODE_JCGL_FILE_TYPE_XLS = "xls";
    public static final String DICT_CODE_JCGL_FILE_TYPE_PDF = "pdf";

    /*****
     * 角色类别:JCGL_ROLE_CATEGORY
     * 01-普通角色
     * 02-超级管理员角色
     * 03-基础管理系统单位负责人角色
     * 04-执法人员系统全省执法人员角色
     * 05-协同办案系统经办机构负责人角色
     * 06-协同办案系统单位负责人角色
     * 07-协同办案系统单位法制机构审核人角色
     * 08-协同办案系统案件注销审批人员角色
     */
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY = "JCGL_ROLE_CATEGORY";
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY_01 = "01";
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY_02 = "02";
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY_03 = "03";
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY_04 = "04";
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY_05 = "05";
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY_06 = "06";
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY_07 = "07";
    public static final String DICT_CODE_JCGL_ROLE_CATEGORY_08 = "08";

    /*****
     * 短信息类别
     */
    public static final String DICT_CODE_SMS_TYPE = "SMS_CODE";
}
