package com.kdgcsoft.jt.xzzf.dubbo.system.app.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.app.entity.AppLoginLog;

import java.util.List;

/****
 * @className AppLoginLogService
 * @author ChrisYolanda
 * @description App登录日志服务层接口
 * @version 1.0
 * @date 2020-11-25 16:51
 */
public interface AppLoginLogService {

    /******
     * 新增信息
     * @param appLoginLog
     * @return
     */
    boolean insert(AppLoginLog appLoginLog);

    /*****
     * 修改信息
     * @param appLoginLog
     * @return
     */
    boolean updateById(AppLoginLog appLoginLog);

    /*****
     * 根据ID删除信息
     * @param id 　ID
     * @return
     */
    boolean deleteById(String id);

    /******
     * 根据ID获取信息
     * @param id
     * @return
     */
    AppLoginLog getById(String id);

    /*******
     * 分页查询
     * @param current     当前页
     * @param size        每页显示条数
     * @param appLoginLog
     * @return
     */
    Page<AppLoginLog> page(long current, long size, AppLoginLog appLoginLog);

    /*******
     * 获取App登录历史信息
     * @param startTime 开始日期
     * @param endTime  截止日期
     * @param appCode app编码
     * @return
     */
    List<ComboboxVo> getAppLoginHisInfoByAppCode(String startTime, String endTime, String appCode);

    /****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<AppLoginLog> page(Page<AppLoginLog> page, AppLoginLog entity);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @return
     */
    List<AppLoginLog> export(AppLoginLog entity, String ids);

    /*****
     * 获取登录日志记录信息
     * @param id 主键ID
     * @return
     */
    AppLoginLog getEntityInfoById(String id);
}
