package com.kdgcsoft.jt.xzzf.dubbo.system.app.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/****
 * @className ErrorLog
 * @author chris
 * @description APP登录日志实体类
 * @version 1.0
 * @date 2020-07-28 11:42
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_BASE + "APP_LOGIN_LOG")
public class AppLoginLog extends BaseEntity<String> {
    /**
     * 主键
     */
    private String id;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 手机型号
     */
    private String phoneType;

    /**
     * 登录时间
     */
    private Date loginTime;

    /**
     * 行政区划编码
     */
    private String areaCode;

    /**
     * 行政区划名称
     */
    private String areaName;

    /**
     * 机构ID
     */
    private String orgId;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * APP类型
     */
    private String appCode;

    /**
     * APP类型Text文本值
     */
    @TableField(exist = false)
    private String appCodeText;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
