package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.util;



import org.apache.commons.lang.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


/**
 * 日期处理工具类
 */
public class DateUtil {

	public static String nowY() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
		return sdf.format(new Date());
	}
	public static String nowYm() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		return sdf.format(new Date());
	}

	public static String nowYmd() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
		return sdf.format(new Date());
	}

	public static String nowYmdhm() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
		return sdf.format(new Date());
	}

	public static String nowYmdHms() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		return sdf.format(new Date());
	}

	public static String nowYmdHms(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		return sdf.format(date);
	}

	public static String toDateStr(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(date);
	}

	public static String toTodayStartStr() {
		return toDateStr(new Date()) + " 00:00:00";
	}

	public static Date toTodayStartTime() {
		return DateUtil.toDate(toTodayStartStr());
	}

	public static String toTodayEndStr() {
		return toDateStr(new Date()) + " 23:59:59";
	}

	public static Date toTodayEndTime() {
		return DateUtil.toDate(DateUtil.toTodayEndStr(), "yyyy-MM-dd HH:mm:ss");
	}

	public static String toDateStr(Date date, String fmt) {
		SimpleDateFormat sdf = new SimpleDateFormat(fmt);
		return sdf.format(date);
	}

	public static Date toDate(String date) {
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			return sdf.parse(date);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String changeDate(String date) {
		try {
			if(StringUtils.isEmpty(date)){
				return null;
			}
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			return  toDateStr(sdf.parse(date));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String changeDateYMS(String date) {
		try {
			if(StringUtils.isEmpty(date)){
				return null;
			}
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			return  fmtYmdHms(sdf.parse(date));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static Date toDate(String date, String fmt) {
		try {
			SimpleDateFormat sdf = new SimpleDateFormat(fmt);
			return sdf.parse(date);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String fmtYmdHms(Date date) {
		if (date == null) {
			return "";
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(date);
	}

	public static Date toYmdHms(String date) {
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			return sdf.parse(date);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 获取结束时间
	 * @param date
	 * @return
	 */
	public static String formatEndTime(String date){
		if(StringUtils.isEmpty(date)){
			return null;
		}

		return date + " 23:59:59";
	}

	/**
	 * 获取几年前的今天
	 * @param year
	 * @return
	 */
	public static String getNumYearAge(Integer year) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		Calendar c = Calendar.getInstance();
		//过去一年
		c.setTime(new Date());
		c.add(Calendar.YEAR, -year);
		Date y = c.getTime();
		String date = format.format(y);
		System.out.println("过去一年："+date);
		return date;
	}

	/**
	 * 获取近三年集合
	 * @return
	 */
	public static List<String> queryThree(){
		List<String> resultList = new ArrayList<>();

		Calendar cal = Calendar.getInstance();
		//近三年
		int nowYear = cal.get(Calendar.YEAR);
		int nextYear = nowYear - 1 ;
		int lastYear = nowYear - 2 ;
		resultList.add(String.valueOf(nowYear));
		resultList.add(String.valueOf(nextYear));
		resultList.add(String.valueOf(lastYear));

		return resultList;
	}

	public static void main(String[] args) {
		System.out.println(formatEndTime("2020-08-19"));
	}


}
