package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity.PykhJPcbz;

import java.util.List;


/**
 * <p>
 * 评查标准 服务类
 * </p>
 *
 * @author LSH
 * @since 2020-08-26
 */
public interface PykhJPcbzService {
    /**
     * 新增评查标准信息
     *
     * @param pykhJPcbz
     * @return
     */
    boolean insert(PykhJPcbz pykhJPcbz);

    /**
     * 修改评查标准信息
     *
     * @param pykhJPcbz
     * @return
     */
    boolean updateById(PykhJPcbz pykhJPcbz);

    /**
     * 根据ID删除评查标准信息
     *
     * @param id　评查标准ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取评查标准信息
     *
     * @param id
     * @return
     */
    PykhJPcbz getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param pykhJPcbz
     * @return
     */
    Page<PykhJPcbz> page(long current, long size, PykhJPcbz pykhJPcbz);

    /***
     * 查询启用日期为当前日期的标准集合
     * @return
     */
    public List<String> queryQyrqIsToday();

    /**
     * 更新启用日期为当前日期的标准
     * @return
     */
    public int updateTodayZt(List<String> list);


}
