package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity.PykhJKprw;


/**
 * <p>
 * 考评任务 服务类
 * </p>
 *
 * @author LSH
 * @since 2020-06-01
 */
public interface PykhJKprwService {

    /**
     * 新增考评任务信息
     *
     * @param pykhJKprw
     * @return
     */
    boolean insert(PykhJKprw pykhJKprw);

    /**
     * 修改考评任务信息
     *
     * @param pykhJKprw
     * @return
     */
    boolean updateById(PykhJKprw pykhJKprw);

    /**
     * 根据ID删除考评任务信息
     *
     * @param id　考评任务ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取考评任务信息
     *
     * @param id
     * @return
     */
    PykhJKprw getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param pykhJKprw
     * @return
     */
    Page<PykhJKprw> page(long current, long size, PykhJKprw pykhJKprw);

    /**
     * 查询考评任务ID
     * @param ksxxId
     * @return
     */
     String queryKpRwIdByKsXxId(String ksxxId);


}

