package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity.PykhJDxaj;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.DxAjInfoVO;

/**
 * <p>
 * 典型案卷 服务类
 * </p>
 *
 * @author LSH
 * @since 2020-09-21
 */
public interface PykhJDxajService {

    /**
     * 新增典型案卷信息
     *
     * @param pykhJDxaj
     * @return
     */
    boolean insert(PykhJDxaj pykhJDxaj);

    /**
     * 修改典型案卷信息
     *
     * @param pykhJDxaj
     * @return
     */
    boolean updateById(PykhJDxaj pykhJDxaj);

    /**
     * 根据ID删除典型案卷信息
     *
     * @param id　典型案卷ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取典型案卷信息
     *
     * @param id
     * @return
     */
    PykhJDxaj getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param pykhJDxaj
     * @return
     */
    Page<PykhJDxaj> page(long current, long size, PykhJDxaj pykhJDxaj);

    /**
     * 分页查询
     * @param page
     * @return
     */
    public Page<DxAjInfoVO> queryPage(Page page, DxAjInfoVO dxAjInfoVO);

}

