package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity.KprwVo;
import com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity.KpzVo;
import com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity.PykhJKpzcyVO;

public interface IPykhJKpzcyService {
    /**
     * 新增姓名，是否组长，联系方式，所属单位名称
     信息
     *
     * @param pykhJKpzcyVO
     * @return
     */
    boolean insert(PykhJKpzcyVO pykhJKpzcyVO);

    /**
     * 修改姓名，是否组长，联系方式，所属单位名称
     信息
     *
     * @param pykhJKpzcyVO
     * @return
     */
    boolean updateById(PykhJKpzcyVO pykhJKpzcyVO);

    /**
     * 根据ID删除姓名，是否组长，联系方式，所属单位名称
     信息
     *
     * @param id　姓名，是否组长，联系方式，所属单位名称
    ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取姓名，是否组长，联系方式，所属单位名称
     信息
     *
     * @param id
     * @return
     */
    PykhJKpzcyVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param pykhJKpzcyVO
     * @return
     */
    Page<PykhJKpzcyVO> page(long current, long size, PykhJKpzcyVO pykhJKpzcyVO);

    /**
     * 查询用户考评组信息
     * @param userId 用户id
     * @return
     */
    public KpzVo queryPykhJKpzcyByUserId(String userId);

    /**
     * 查询用户考评任务信息
     * @param userId 用户id
     * @return
     */
    public KprwVo queryPykhJKprwByUserId(String userId,String ksxxId);
}
