package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity.KprwZfryGlVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.KsXxVO;

import java.util.List;

/**
 * <p>
 * 被抽取的人员列表 服务类
 * </p>
 *
 * @author LSH
 * @since 2020-05-25
 */
public interface IKprwZfryGlService{

    /**
     * 新增被抽取的人员列表信息
     *
     * @param kprwZfryGl
     * @return
     */
    boolean insert(KprwZfryGlVO kprwZfryGl);

    /**
     * 修改被抽取的人员列表信息
     *
     * @param kprwZfryGl
     * @return
     */
    boolean updateById(KprwZfryGlVO kprwZfryGl);

    /**
     * 根据ID删除被抽取的人员列表信息
     *
     * @param id　被抽取的人员列表ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取被抽取的人员列表信息
     *
     * @param id
     * @return
     */
    KprwZfryGlVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param kprwZfryGl
     * @return
     */
    Page<KprwZfryGlVO> page(long current, long size, KprwZfryGlVO kprwZfryGl);

    /**
     * 查询对应的考试信息对应考评任务的执法人员列表
     * @param ksxxId
     * @return
     */
    public List<KsXxVO> queryZfryList(String ksxxId);

    /**
     * 更新考评任务执法人员关联表
     * @param kprwZfryGlVO
     * @return
     */
    boolean updateKpRwZfRyInfo(KprwZfryGlVO kprwZfryGlVO);

}

