package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 评查标准
 * </p>
 *
 * @author LSH
 * @since 2020-05-19
 */
@Data
@TableName("PYKH_J_PCBZ")
public class PykhJPcbz extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 评查标准的唯一标识
     */
    @TableId
    private String pcbzId;

    /**
     * 版本号
     */
    private String bbh;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 评查对象代码
     */
    private String pcdxdm;

    /**
     * 案件类型代码
     */
    private String ajlxdm;

    /**
     * 评查标准名称
     */
    private String bzmc;

    /**
     * 时间范围起
     */
    private Date sjfwq;

    /**
     * 时间范围止
     */
    private Date sjfwz;

    /**
     * 启用日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qyrq;

    /**
     * 禁用日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jyrq;

    /**
     * 状态：0 暂存 1 待启用 2 启用 3 禁用
     */
    private String zt;

    /**
     * 00未删除01已删除
     */
    private String deleteFlag;

    /**
     * 修改人
     */
    private String updater;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private String creater;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 评查对象名称
     */
    @TableField(exist = false)
    private String pcdxmc;

    /**
     * 案件类型名称
     */
    @TableField(exist = false)
    private String ajlxmc;

    /**
     * 总层数
     */
    @TableField(exist = false)
    private String zcs;

    /**
     * 制定单位
     */
    @TableField(exist = false)
    private String zddw;

    /**
     * 启用日期
     */
    @TableField(exist = false)
    private String qyrqDate;


    @Override
    public String getId() {
        return pcbzId;
    }

    @Override
    public void setId(String id) {
        this.pcbzId = id;
    }


}
