package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 考评任务
 * </p>
 *
 * @author LSH
 * @since 2020-05-29
 */
@Data
@TableName("PYKH_J_KPRW")
public class PykhJKprw extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 考评任务的唯一标识
     */
    @TableId
    private String kprwId;

    /**
     * 考评组的唯一标识
     */
    private String kpzId;

    /**
     * 考评批次的唯一标识。
     */
    private String kppcId;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 考评时间起
     */
    private Date kpsjq;

    /**
     * 考评时间止
     */
    private Date kpsjz;

    /**
     * 状态：0 未开始，1 已抽取，2 评查中，3 已完成，4 已报送
     */
    private String zt;


    /**
     * 工作报告，多个附件以逗号隔开
     */
    private String gzbg;


    /**
     * 被考评机构名称
     */
    private String bkpjgmc;

    /**
     * 考试信息id
     */
    private String ksxxId;

    /**
     * 考试信息id
     */
    private BigDecimal zgbmdf;

    /**
     * 主管部门得分
     */
    private BigDecimal zfjgdf;

    /**
     * 执法机构得分
     */
    private BigDecimal ryksdf;

    /**
     * 案卷得分
     */
    private BigDecimal ajdf;

    /**
     * 最终得分
     */
    private BigDecimal zzdf;


    @Override
    public String getId() {
        return kprwId;
    }

    @Override
    public void setId(String id) {
        this.kprwId = id;
    }

}
