package com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 日常评查里对应案卷的信息
 * </p>
 *
 * @author LSH
 * @since 2020-06-24
 */
@Data
@TableName("KPJL_AJ_GL")
public class KpjlAjGl extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 考评记录表的唯一标识
     */
    @TableId
    private String kpjlbId;

    /**
     * 案件信息ID
     */
    private String ajxxid;

    /**
     * 案号
     */
    private String ah;

    /**
     * 执法机关ID
     */
    private String zfjgid;

    /**
     * 执法机关名称
     */
    private String zfjgmc;

    /**
     * 当事人名称
     */
    private String dsrmc;

    /**
     * 行业代码
     */
    private String hydm;

    /**
     * 案卷评查类型代码
     */
    private String ajpclxdm;

    /**
     * 车船号
     */
    private String cch;

    /**
     * 案由
     */
    private String ay;

    /**
     * 受案时间
     */
    private Date sasj;

    /**
     * 行政决定时间
     */
    private Date xzjdsj;

    /**
     * 结案时间
     */
    private Date jasj;

    /**
     * 处罚金额
     */
    private BigDecimal cfje;

    /**
     * 工作流id（协同办案系统处获取）
     */
    private String eventId;
    /**
     * 处理人ID(多个处理人逗号分隔)
     */
    private String clrId;

    /**
     * 00未删除01已删除
     */
    private String deleteFlag;

    /**
     * 创建人
     */
    private String creater;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String updater;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 案卷状态
     */
    private String zt;

    @Override
    public String getId() {
        return kpjlbId;
    }

    @Override
    public void setId(String id) {
        this.kpjlbId = id;
    }


}
