package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.GroupComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglZbplVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglZbplService
 * @author chris
 * @description 装备品类服务层接口
 * @version 1.0
 * @date 2021-04-14 18:01
 */
public interface ZbglZbplService {

    /******
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZbglZbplVo> pageData(Page<ZbglZbplVo> page, ZbglZbplVo entity, String belongOrgId);

    /*****
     * 保存数据
     * @param entity
     * @param isCreate
     * @param curUser
     */
    void saveOrUpdate(ZbglZbplVo entity, boolean isCreate, SysUser curUser);

    /*****
     * 删除数据
     * @param ids
     * @param curUser 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser curUser);

    /****
     * 获取数据
     * @param id 主键Id
     * @return
     */
    ZbglZbplVo getEntityInfoById(String id);

    /*******
     * 获取下一个序号
     * @return
     */
    Integer getEntityInfoNextOrderNo();

    /*****
     * 修改状态
     * @param ids 主键Id集合
     * @param curUser 当前登录用户
     */
    void modifyStatusDataByIds(String ids, SysUser curUser);

    /*****
     * 查询下拉框的键值对
     * @param filter 关键字过滤
     * @return
     */
    List<GroupComboboxVo> queryEntityInfoGroupCombobox(String filter);
}
