package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglZbmcVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglZbmcService
 * @author chris
 * @description 装备名称服务层接口
 * @version 1.0
 * @date 2021-04-14 20:55
 */
public interface ZbglZbmcService {

    /******
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZbglZbmcVo> pageData(Page<ZbglZbmcVo> page, ZbglZbmcVo entity, String belongOrgId);

    /******
     * 列表查询
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ZbglZbmcVo> listData(ZbglZbmcVo entity, String belongOrgId);

    /*****
     * 保存数据
     * @param entity
     * @param isCreate
     * @param curUser
     */
    void saveOrUpdate(ZbglZbmcVo entity, boolean isCreate, SysUser curUser);

    /*****
     * 删除数据
     * @param ids
     * @param curUser 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser curUser);

    /****
     * 获取数据
     * @param id 主键Id
     * @return
     */
    ZbglZbmcVo getEntityInfoById(String id);

    /*******
     * 获取下一个序号
     * @return
     */
    Integer getEntityInfoNextOrderNo();

    /*****
     * 修改状态
     * @param ids 主键Id集合
     * @param curUser 当前登录用户
     */
    void modifyStatusDataByIds(String ids, SysUser curUser);

    /******
     * 获取装备名称总数
     * @param zbplId 装备品类Id
     * @return
     */
    Integer getEntityInfoTotalByZbplId(String zbplId);

    /*****
     * 查询下拉框的键值对
     * @param filter 关键字过滤
     * @return
     */
    List<ComboboxVo> queryEntityInfoCombobox(String filter);
}
