package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzsqmxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglFzbzsqmxService
 * @author chris
 * @description 服装标志申请明细服务层接口
 * @version 1.0
 * @date 2021-05-17 10:45
 */
public interface ZbglFzbzsqmxService {

    /*******
     * 保存服装标志申请明细信息
     * @param fzbzsqId 服装标志申请Id
     * @param detailInfo 申请明细信息
     * @param curUser 当前登录用户
     */
    void saveFzbzsqDetailInfo(String fzbzsqId, String detailInfo, SysUser curUser);

    /*******
     * 获取服装标志申请明细信息
     * @param fzbzsqId 服装标志申请Id
     * @return
     */
    List<ZbglFzbzsqmxVo> getEntityListDataByFzbzsqId(String fzbzsqId);

    /*****
     * 删除服装标志申请明细信息
     * @param fzbzsqId 服装标志申请Id
     * @param curUser 当前登录用户
     */
    void deleteDataByFzbzsqId(String fzbzsqId, SysUser curUser);
}
