package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzsqVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

/****
 * @className ZbglFzbzsqService
 * @author chris
 * @description 服装标志申请服务层接口
 * @version 1.0
 * @date 2021-04-25 10:14
 */
public interface ZbglFzbzsqService {

    /******
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @param curUser 当前登录用户
     * @return
     */
    Page<ZbglFzbzsqVo> pageData(Page<ZbglFzbzsqVo> page, ZbglFzbzsqVo entity, String belongOrgId, SysUser curUser);

    /*****
     * 获取数据
     * @param id 主键ID
     * @return
     */
    ZbglFzbzsqVo getEntityInfoById(String id);

    /*******
     * 保存申请
     * @param entity
     * @param isCreate
     * @param isApply
     * @param curUser
     */
    void saveOrUpdate(ZbglFzbzsqVo entity, boolean isCreate, boolean isApply, SysUser curUser);

    /*****
     * 删除数据
     * @param ids
     * @param curUser 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser curUser);

    /*****
     * 更新数据审批状态
     * @param fzbzsqId 服装标志申请Id
     * @param spzt 审批状态
     * @param curUser 当前登录用户
     */
    void updateEntityInfoSpztByFzbzsqId(String fzbzsqId, String spzt, SysUser curUser);
}
