package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzspmxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglFzbzspmxService
 * @author chris
 * @description 服装标志审批明细服务层接口
 * @version 1.0
 * @date 2021-05-24 15:45
 */
public interface ZbglFzbzspmxService {

    /*******
     * 获取服装标志审批明细信息
     * @param fzbzspId 服装标志审批Id
     * @return
     */
    List<ZbglFzbzspmxVo> getEntityListDataByFzbzspId(String fzbzspId);

    /*******
     * 获取到期更换装备列表
     * @param zfryId 执法人员Id
     * @return
     */
    List<ZbglFzbzspmxVo> queryQmhfList(String zfryId);

    /*******
     * 服装标志汇总上报---审批明细汇总分页
     * @param fzbzspId 服装标志审批Id
     * @return
     */
    List<ZbglFzbzspmxVo> querySpmxhzPage(String fzbzspId);

    /******
     * 物理删除服装标志审批明细
     * @param fzbzsqId 服装标志申请Id
     */
    void deleteEntityInfoByFzbzsqId(String fzbzsqId);

    /******
     * 保存服装标识审批明细信息
     * @param fzbzspId 服装标志审批Id
     * @param detailInfo 申请明细信息
     * @param curUser 当前登录用户
     */
    void saveZbglFzbzspmxInfo(String fzbzspId, String detailInfo, SysUser curUser);

    /*******
     * 保存首发登记审批明细信息
     * @param sfdjId 首发登记Id
     * @param fzbzspId 服装标志审批Id
     * @param detailInfo 首发登记明细信息
     * @param curUser 当前登录用户
     */
    void saveSfdjFzbzspmxInfo(String sfdjId, String fzbzspId, String detailInfo, SysUser curUser);
}
